<?php

namespace App\Helpers;

class GravatarHelper
{
    /**
     * Generate Gravatar URL
     */
    public static function getUrl(string $email, int $size = 50, string $default = 'mp'): string
    {
        $hash = md5(strtolower(trim($email)));
        
        return "https://www.gravatar.com/avatar/{$hash}?" . http_build_query([
            's' => $size,
            'd' => $default,
        ]);
    }
    
    /**
     * Get Gravatar image tag
     */
    public static function getImage(string $email, string $name, int $size = 50, array $attributes = []): string
    {
        $url = self::getUrl($email, $size);
        $attributes = array_merge([
            'src' => $url,
            'alt' => "Avatar for {$name}",
            'width' => $size,
            'height' => $size,
            'class' => 'gravatar rounded-circle',
            'loading' => 'lazy',
        ], $attributes);
        
        $attrs = '';
        foreach ($attributes as $key => $value) {
            $attrs .= " {$key}=\"" . e($value) . "\"";
        }
        
        return "<img{$attrs}>";
    }
}