<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class services extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:service {name}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'create services';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $name = $this->argument('name');
        $path = base_path("/app/Services");

        if (!File::exists($path)) {
            File::makeDirectory($path, 0755, true);
        }

        $classname = Str::studly($name);

        $filepath = "{$path}/{$classname}.php";

        if (File::exists($filepath)) {
            $this->error('service exists!');
            return;
        }

        $st =

            <<<EOT
<?php
       
       namespace App\\Services;
       
           class {$classname}
           {
       
               public function __construct()
           {
           //
           }
       
           }
EOT;

        File::put($filepath, $st);
        $this->info('services Created!');
    }
}
